<?php
// Configuration
$crm_base_url = 'https://crm.codemoly.com';
$api_endpoint = '/api/leads';
$api_key = 'eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyIjoibGVhZF9zeW5jIiwibmFtZSI6ImxlYWRfc3luYyIsIkFQSV9USU1FIjoxNzQxODU4MjA1fQ.e91Ig_XKj2k06QUb8x5mSYLYSVM363ZURJrGD3HZymY';

// Google Sheet ID
$spreadsheet_id = '1xCLRlEn2M4KV0TEy07XdqGD1GZv0NbzNu88JoFvGDM8';

// Employee IDs for Round-Robin Assignment
$employees = [11, 12, 22];

// Tracking file
$tracking_file = __DIR__ . '/lead_sync_tracking.json';
$log_file = __DIR__ . '/lead_sync.log';
$error_log_file = __DIR__ . '/lead_sync_error.log';

// Function to log messages
function logMessage($message, $is_error = false) {
    global $log_file, $error_log_file;
    $timestamp = date('Y-m-d H:i:s');
    $log_entry = "[{$timestamp}] {$message}" . PHP_EOL;
    
    if ($is_error) {
        file_put_contents($error_log_file, $log_entry, FILE_APPEND);
    } else {
        file_put_contents($log_file, $log_entry, FILE_APPEND);
    }
    
    echo $log_entry;
}

// Function to download CSV from Google Sheets
function downloadGoogleSheetCSV($spreadsheet_id) {
    $csv_export_url = "https://docs.google.com/spreadsheets/d/{$spreadsheet_id}/export?format=csv";
    
    $options = [
        'http' => [
            'method' => 'GET',
            'header' => "Accept: text/csv\r\n"
        ]
    ];
    
    $context = stream_context_create($options);
    $csv_data = file_get_contents($csv_export_url, false, $context);
    
    if ($csv_data === false) {
        throw new Exception("Failed to download Google Sheet data");
    }
    
    return $csv_data;
}

// Function to parse CSV data
function parseCSV($csv_data) {
    $lines = explode("\n", $csv_data);
    
    if (empty($lines)) {
        throw new Exception("Empty CSV data received");
    }
    
    $headers = str_getcsv(array_shift($lines));
    logMessage("CSV Headers: " . implode(", ", $headers));
    
    $data = [];
    foreach ($lines as $line) {
        if (empty(trim($line))) continue;
        $row = str_getcsv($line);
        
        // Make sure we have the right number of columns
        if (count($row) == count($headers)) {
            $data[] = array_combine($headers, $row);
        }
    }
    
    return $data;
}

// Function to add a lead to Perfex CRM
function addLeadToCRM($lead_data, $crm_base_url, $api_endpoint, $api_key, $assigned_to) {
    // Extract the specific fields we need
    $name = isset($lead_data['full_name']) ? $lead_data['full_name'] : '';
    $phone = isset($lead_data['phone_number']) ? $lead_data['phone_number'] : '';
    $business_type = isset($lead_data['আপনার_ব্যবসার_ধরণ?']) ? $lead_data['আপনার_ব্যবসার_ধরণ?'] : '';
    
    // Clean up phone number (remove p: prefix if present)
    $phone = str_replace('p:', '', $phone);
    
    // Verify we have the required fields
    if (empty($name)) {
        throw new Exception("Missing required field: full_name");
    }
    
    // Create lead data structure for Perfex CRM API
    $lead = [
        'name' => $name,
        'status' => 1,  // Make sure this matches a valid status ID in your CRM
        'source' => 2,  // Make sure this matches a valid source ID in your CRM
        'assigned' => $assigned_to,
        'description' => "Lead from Facebook Ads\nBusiness Type: {$business_type}"
    ];
    
    // Add phone if available
    if (!empty($phone)) {
        $lead['phonenumber'] = $phone;
    }
    
    // Log what we're sending
    logMessage("Sending lead to CRM: " . json_encode($lead));
    
    // Set up cURL request
    $ch = curl_init($crm_base_url . $api_endpoint);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($lead));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'authtoken: ' . $api_key
    ]);
    
    // Execute request
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    // Check for cURL errors
    if (curl_errno($ch)) {
        $error = curl_error($ch);
        curl_close($ch);
        throw new Exception("cURL Error: {$error}");
    }
    
    curl_close($ch);
    
    // Log the response
    logMessage("API Response (HTTP {$http_code}): {$response}");
    
    // Check for API errors
    $result = json_decode($response, true);
    if ($http_code >= 400 || (isset($result['status']) && $result['status'] === false)) {
        $error_message = isset($result['message']) ? $result['message'] : "Unknown API error";
        throw new Exception("API Error: {$error_message}");
    }
    
    return $result;
}

// Function to load tracking data
function loadTrackingData($tracking_file) {
    if (file_exists($tracking_file)) {
        $data = json_decode(file_get_contents($tracking_file), true);
        if (json_last_error() === JSON_ERROR_NONE) {
            return $data;
        }
    }
    
    return [
        'current_employee_index' => 0,
        'processed_leads' => []
    ];
}

// Function to save tracking data
function saveTrackingData($tracking_file, $tracking_data) {
    file_put_contents($tracking_file, json_encode($tracking_data));
}

// Main script execution
try {
    logMessage("Starting lead sync script");
    
    // Load tracking data
    $tracking_data = loadTrackingData($tracking_file);
    logMessage("Loaded tracking data. Current employee index: {$tracking_data['current_employee_index']}");
    
    // Download and parse the Google Sheet
    logMessage("Downloading Google Sheet data");
    $csv_data = downloadGoogleSheetCSV($spreadsheet_id);
    $leads = parseCSV($csv_data);
    logMessage("Found " . count($leads) . " leads in the Google Sheet");
    
    // Get the current employee index for round-robin
    $employee_index = $tracking_data['current_employee_index'];
    
    // Process each lead
    $new_leads_added = 0;
    foreach ($leads as $lead) {
        // Use phone as the unique identifier
        $phone = isset($lead['phone_number']) ? str_replace('p:', '', $lead['phone_number']) : '';
        
        if (empty($phone)) {
            logMessage("Skipping lead with no phone number");
            continue;
        }
        
        // Skip already processed leads
        if (in_array($phone, $tracking_data['processed_leads'])) {
            logMessage("Skipping already processed lead: {$phone}");
            continue;
        }
        
        logMessage("Processing new lead: {$phone}");
        
        // Assign the lead to the next employee in round-robin
        $assigned_to = $employees[$employee_index];
        logMessage("Assigning to employee ID: {$assigned_to}");
        
        try {
            // Add the lead to CRM
            $response = addLeadToCRM($lead, $crm_base_url, $api_endpoint, $api_key, $assigned_to);
            
            // Update tracking data
            $tracking_data['processed_leads'][] = $phone;
            $employee_index = ($employee_index + 1) % count($employees);
            $new_leads_added++;
            
            logMessage("Successfully added lead: {$phone}, Assigned to: {$assigned_to}");
        } catch (Exception $e) {
            logMessage("Failed to add lead {$phone}: " . $e->getMessage(), true);
        }
    }
    
    // Update and save tracking data
    $tracking_data['current_employee_index'] = $employee_index;
    saveTrackingData($tracking_file, $tracking_data);
    
    logMessage("Script completed successfully. {$new_leads_added} new leads added to CRM.");
    
} catch (Exception $e) {
    logMessage("ERROR: " . $e->getMessage(), true);
    echo "Error: " . $e->getMessage() . "\n";
}